
var calendar; // Variável global

document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendar');

    calendar = new FullCalendar.Calendar(calendarEl, {
        locale: 'pt-br',
        plugins: ['interaction', 'dayGrid'],
        editable: true,
        eventLimit: true,
        events: 'list_eventos.php',
        extraParams: function () {
            return {
                cachebuster: new Date().valueOf()
            };
        },
        eventClick: function (info) {
            $("#apagar_evento").attr("href", "proc_apagar_evento.php?id=" + info.event.id);
            info.jsEvent.preventDefault();

            // Visualização
            $('#visualizar #id_view').text(info.event.id);
            $('#visualizar #title_view').text(info.event.title);
            $('#visualizar #start_view').text(info.event.start.toLocaleString());
            $('#visualizar #doctor_view').text(info.event.extendedProps.doctor);

            // Edição
            $('#visualizar #id_edit').val(info.event.id);
            $('#visualizar #title_edit').val(info.event.title);
            $('#visualizar #start_edit').val(info.event.start.toLocaleString());
            $('#visualizar #color_edit').val(info.event.backgroundColor);
            $('#visualizar #doctor_edit').val(info.event.extendedProps.doctor);

            $('#visualizar').modal('show');
        },
        selectable: true,
        select: function (info) {
            $('#cadastrar #start').val(info.start.toLocaleString());
            $('#cadastrar #end').val(info.end.toLocaleString());
            $('#cadastrar').modal('show');
        }
    });

    calendar.render();
});

$(document).ready(function () {
    $("#addevent").on("submit", function (event) {
        event.preventDefault();
        $.ajax({
            method: "POST",
            url: "cad_event.php",
            data: new FormData(this),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (retorna) {
                if (retorna['sit']) {
                    $('#cadastrar').modal('hide');
                    calendar.refetchEvents();
                } else {
                    $("#msg-cad").html(retorna['msg']);
                }
            }
        })
    });

    $('.btn-canc-vis').on("click", function(){
        $('.visevent').slideToggle();
        $('.formedit').slideToggle();
    });

    $('.btn-canc-edit').on("click", function(){
        $('.formedit').slideToggle();
        $('.visevent').slideToggle();
    });

    $("#editevent").on("submit", function (event) {
        event.preventDefault();
        $.ajax({
            method: "POST",
            url: "edit_event.php",
            data: new FormData(this),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (retorna) {
                if (retorna['sit']) {
                    $('#visualizar').modal('hide');
                    calendar.refetchEvents(); // Agora funciona corretamente
                } else {
                    $("#msg-edit").html(retorna['msg']);
                }
            }
        })
    });
});
