<?php
session_start();
require_once 'conexao.php'; // Certifique-se de que esta conexão retorna um objeto PDO

if (!isset($_SESSION['nome']) || !isset($_SESSION['login'])) {
    header('Location: https://agenda.kaltekgoiania.com.br/');
    exit;
}

$login = $_SESSION['login'];
$mensagem = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nova_senha = $_POST['nova_senha'] ?? '';

    if (empty($nova_senha)) {
        $mensagem = "A nova senha não pode estar vazia.";
    } else {
        try {
            $sql = "UPDATE usuarios SET senha = :senha WHERE login = :login";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':senha', $nova_senha);
            $stmt->bindParam(':login', $login);

            if ($stmt->execute()) {
                $_SESSION['senha'] = $nova_senha; // Opcional
                header('Location: https://agenda.kaltekgoiania.com.br/'); // Redireciona ao finalizar
                exit;
            } else {
                $mensagem = "Erro ao atualizar a senha.";
            }
        } catch (PDOException $e) {
            $mensagem = "Erro no banco de dados: " . $e->getMessage();
        }
    }
}
?>
